//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.5

import wesual.Stage 1.0
import wesual.Ui     1.0

ContainerOption {
    defaultValue : 0

    property string label
    property string text

    readonly property bool checked : value || false

    Column {
        property ContainerOption containerOption

        spacing : 9

        UiLabel { text : containerOption ? containerOption.label : "" }

        UiToggle {
            bindable  : true
            text      : containerOption ? containerOption.text : ""
            checked   : containerOption ? containerOption.value : false
            onClicked : containerOption.updateValue(!containerOption.value)
        }
    }
}
